//
//  GameScene.swift
//  iPhone lecture
//
//  Created by Simon Voelker on 01/12/15.
//  Copyright (c) 2015 i10. All rights reserved.
//

import SpriteKit
import AVFoundation


// canvas size for the positioning
let canvasWidth: UInt32 = 800
let canvasHeight: UInt32 = 800

// From the docs:
// When a physics body is inside the region of a SKFieldNode object, that field node’s categoryBitMask property is
// compared to this physics body’s fieldBitMask property by performing a logical AND operation.
// If the result is a non-zero value, then the field node’s effect is applied to the physics body.
let fieldMask : UInt32 = 0b1
let categoryMask: UInt32 = 0b1

class GameScene: SKScene {
    

    
    override func didMoveToView(view: SKView) {
        /* Setup your scene here */
        
        
    
        

          let fieldNode: SKFieldNode
        
        fieldNode = SKFieldNode.magneticField()
        // we define its body
        fieldNode.physicsBody = SKPhysicsBody(circleOfRadius: 80)
        // we add it to the display list (tree)
        fieldNode.categoryBitMask = categoryMask
        // strength of the field
        fieldNode.strength = 2.8
        
      
        
        // we set the background color to black, self is the equivalent of this in Flash
        self.scene?.backgroundColor = UIColor(red: 0, green: 0, blue: 0, alpha: 1)
        // we live in a world with gravity
        self.physicsWorld.gravity = CGVectorMake(0, -1)
        // we put contraints on the top, left, right, bottom so that our balls can bounce off them
        let physicsBody = SKPhysicsBody (edgeLoopFromRect: self.frame)
        // we set the body defining the physics to our scene
        self.physicsBody = physicsBody
        // we add it to the display list
        
        fieldNode.name = "field"
        self.addChild(fieldNode)
        
    
        let node = SKNode()
        let myLabel = SKLabelNode(fontNamed:"Chalkduster")
        myLabel.text = "Hello, World!";
        myLabel.fontSize = 45;
        myLabel.position = CGPoint(x:CGRectGetMidX(self.frame), y:CGRectGetMidY(self.frame));
        
        self.addChild(myLabel)
        
        let aSKNode = SKNode()
        
        let aCGPoint = CGPointMake(100, 100);
        
        node.containsPoint(aCGPoint)
        
        node.convertPoint(aCGPoint, fromNode: aSKNode)
        
        node.convertPoint(aCGPoint, toNode: aSKNode)
        
        
        for i in 1...300 {
            
            // SkShapeNode is a primitive for drawing like with the AS3 Drawing API
            // it has built in support for primitives like a circle, or a rectangle, here we pass a rectangle
            let shape = SKShapeNode(rect: CGRectMake(-10, -10, 20, 20))
            // we set the color and line style
            shape.strokeColor = UIColor(red: 0, green: 255, blue: 0, alpha: 1)
              shape.fillColor = UIColor(red: 0, green: 0, blue: 255, alpha: 1)
            // we set the stroke width
            shape.lineWidth = 4
            // we set initial random positions
            shape.position = CGPoint (x: CGFloat(arc4random()%(canvasWidth)), y: CGFloat(arc4random()%(canvasHeight)))
            // we add each circle to the display list
            self.addChild(shape)
            // we define the physics body
            shape.physicsBody = SKPhysicsBody(circleOfRadius: shape.frame.size.width/2)
            // from the docs:
            /*The force generated by this field is directed on line that is determined by calculating the cross-product
            between direction fo the the physics body’s velocity property and a line traced between the field node and the
            physics body. The force has a magnitude proportional to the field’s strength property and the physics body’s
            charge and velocity properties.*/
            // we define a mass for the gravity
            shape.physicsBody?.mass = 0.9
            // the charge and field strength are two properties fun tweaking
            shape.physicsBody?.charge = 0.6
            // we set the field mask
            shape.physicsBody?.fieldBitMask = fieldMask
            // this will allow the balls to rotate when bouncing off each other
            shape.physicsBody?.allowsRotation = true
        }
    
      
    }

    
    override func touchesMoved(touches: Set<UITouch>, withEvent event: UIEvent?) {
        
        for touch in touches {
            // we grab the UITouch object in the current scene (self) coordinate
            let touchPos = touch.locationInNode(self)
            // we apply the position of the touch to the physics field node
            self.childNodeWithName("field")!.position = touchPos
        }
    }


   
    override func update(currentTime: CFTimeInterval) {
        /* Called before each frame is rendered */
    }
}
